\ Small example on how to use the Analog-Digital-Converter W.O. 2023
\ Celsius conversion routine built by Albert Nijhof

hex
4004C000 constant ADC-CS            \ ADC Control and Status
4004C004 constant ADC-RESULT        \ Result of most recent ADC conversion

: TEMP          ( -- u )
    3 adc-cs !                      \ Enable ADC and temperature sensor
    begin  100 adc-cs bit** until   \ Wait for READY flag
    4007 adc-cs !                   \ Start conversion on channel 4, temperature sensor
    begin  100 adc-cs bit** until   \ Wait for READY flag
    adc-result @ ;                  \ Fetch conversion result


\ s - in milliVolts
\ c - in hundredths of degrees Celsius
: CELSIUS ( s -- c ) dm 373 dm 100 */ dm 5333 - negate ;

: .TEMP         ( -- )
    base @ >r  decimal              \ Show in decimal
    temp dup .  celsius             \ Show raw voltage & convert temperature
    0 <# # # ch , hold #s #> type   \ Print out
    B0 emit  ." C "  r> base ! ;

: TEMP-DEMO     ( -- )
    begin  cr .temp  key? until ;

\ End
