(* (c) W.O. 2023, RP2040 ASM basic opcodes, vsn 0.5: 6632 Bytes

Immediate:
    Opcod ddd iiiiiiii      8-bit immediate, 1 register, low
    Opcode.... iiiiiii      7-bit immediate, RP implicit
    Opcod iiiii mmm ddd     5-bit immediate, 2 registers, low
    Opcode. iii nnn ddd     3-bit immediate, 2 registers, low
Register:
    Opcode.. d .... ddd     1 register, all
    Opcode....  mmm ...     1 register, low
    Opcode....  mmm ddd     2 registers, low
    Opcode. mmm nnn ddd     3 registers, low
    Opcode.. d mmmm ddd     2 registers, all
    Opcode...  mmmm ...     1 register, all
Push, Pull:
    Opcode.  M rrrrrrrr     R0 to R7 & LI/PC (special case of 8-bit imm)
Diversen:
    Opcode..   ...i....     CPS (Whole 16-bits pattern)
    Opcode..   iiiiiiii     BKP & SVC (Special case of 8-bit imm)
    Opcode..   ........     Whole 16-bits pattern
Branches:em
    Opco cccc  bbbbbbbb    Conditional branch   
    Opcod   bbbbbbbbbbb    Branch
    Opcode.. x mmmm 000    BX & BLX (Special case of 2 register, all)
32-bit opcodes:
    Opcode...... nnnn ........ rrrrrrrr     2 registers, all
    Opcode.. ........ ........ ........     Whole 32-bits pattern
    Opcod S .......... .J.J ...........     Branch & link
*)

here  hex
v: inside also  definitions \ Add register names & addressing modes

' ?text drop

v: extra definitions        \ Additions
: .HEX      ( u -- )            \ Cell wide version of .HEX uses four or more digits
    base @ >r  hex  0 <# # # # #s #> type space  r> base ! ;  v: inside
\ : .DEC      ( u -- )    base @  swap  decimal .  base ! ;

v: forth definitions
: -TRAILING ( a +n1 -- a +n2 )  \ Cut trailing spaces from a string
    begin  2dup + 1- c@ BL = while  1-  repeat ;

v: inside definitions
: .SPECIAL  ( opc -- )
    FF and  dup 0A < if
        5 * s" apsr iapsreapsrxpsr ???  ipsr epsr iepsrmsp  psp  "
        drop  +  5
    else
        dup 10 = if  drop  00  else
        14 = if  8  else  10  then  then
        s" primask control reserved" drop  +  8
    then  -trailing type space ;
: .REG)     ( r -- )                \ Print register names
    0F and  4 *
    s" ip  sp  w   tos hop day sun moonww  xx  yy  zz  doesrp  lr  pc  "
    drop +  4 -trailing type space ;
: .REG      ( opc s m -- )    >r  rshift  r> and .reg) ;  \ Any register field
: .LDREG    ( opc -- )        dup 7 and  swap 80 and 4 rshift or .reg) ; \ Long
: .DSREG    ( opc -- )        dup 0 7 .reg  3 7 .reg ;    \ Decode dest. & src
: @LIT      ( opc s m -- +n ) >r  rshift  r> and ;        \ Any constant field
: .INDIRECT ( opc s m w -- )  >r  @lit  r> * u. ;         \ Constant index
: .CONSTANT ( opc s m w -- )  .indirect ." # " ;          \ Constant type field
: .CONST    ( opc s m -- )    1 .constant ;               \ Simple constant
: .JUMP     ( a o -- )        2*  dup .  ." to " over 4 + +  .hex ; \ Calc. jump
: .REG[]    ( opc w -- )        \ Indexed with offset
    >r  dup 0 7 .reg  dup 3 7 .reg  6 1F r> .indirect  ." x) " ;
: .REGS     ( opc a u f -- )    \ Decode multiple register fields
    ." { "  if  2dup type  then  2drop  \ First special register
    FF and  8 0 do
        dup  1 i lshift and
        if  i .reg)  then
    loop  drop  ." } " ;

: .BL       ( a opc -- a )  \ Branch & link
    dup 4000000 and 0= 0= >r        \ Make & save sign
    -1 7FFFFF xor                   \ Extend sign   opc mask
    r@ and   over 7FF and   or      \ Bit 0 to 10   opc bl..
    over 3FF0000 and 5 rshift  or   \ Bit 11 to 21  opc bl..
    swap -1 xor r> xor  2800 and    \ Isolate bit 21 & 22
    dup >r 800 and A lshift  or     \ Add bit 21
    r> 2000 and 9 lshift or .jump ." bl " ; \ & bit 22

: .BEXX     ( opc -- )      \ Hint & breakpoint opcodes
    dup BF00 = if  ." nop "    then
    dup BF10 = if  ." yield "  then
    dup BF20 = if  ." wfe "    then
    dup BF30 = if  ." wfi "    then
    dup BF40 = if  ." sev "    then
    dup FF00 and  BE00 = if
    0 FF .const  ." bkpt "  else  drop  then ;

: .SXT      ( opc -- )      \ Sign extend opcodes
    dup .dsreg 01C0 and  6 rshift  4 *  s" sxthsxtbuxthuxtb"
    drop +  4 type space ;

: .REV      ( opc -- )      \ Invert opcodes
    dup .dsreg  00C0 and >r
    r@ 0=     if  ." rev "     then
    r@ 0040 = if  ." rev16 "   then
    r> 00C0 = if  ." revsh "   then ;

: .LOGIC    ( opc -- )      \ Logical opcodes
    dup 03C0 and  6 rshift >r  .dsreg  r@ 9 = if  ." #0 "  then  r> 4 *
    s" andseorslslslsrsasrsadcssbcsrorstst rsbscmp cmn orrsmulsbicsmvns"
    drop +  4 -trailing type space  ;

: .BX       ( opc -- )      \ Branch using registers
    dup 3 F .reg  80 and if ." blx " else ." bx " then ;

: .RSP      ( opc -- )      \ Return stack opcodes with 7-bits number
    dup ." rp "  0 7F .const  0080 and if ." sub " else ." add " then ;
 
: .0XXX     ( opc -- )      \ Shift opcodes with 5-bits number
    dup .dsreg  dup 6 1F .const  800 and if ." lsrs " else ." lsls " then ;

: .1XXX     ( opc -- )      \ Shift, add & subtract
    dup 0800 and 0= if dup .dsreg  6 1F .const ." asrs " exit then
    dup 0E00 and >r
    r@ 0800 = if dup .dsreg  6 7 .reg ." adds " then
    r@ 0A00 = if dup .dsreg  6 7 .reg ." subs " then
    r@ 0C00 = if dup .dsreg  6 7 .const ." adds " then
    r> 0E00 = if dup .dsreg  6 7 .const ." subs " then ;

: .2XXX     ( opc -- )      \ Compare & move using 8-bits number
    dup 8 7 .reg  dup 0 FF .const  0800 and if ." cmp " else ." movs " then ;
    
: .3XXX     ( opc -- )      \ Subtract & add using 8-bits number
    dup 8 7 .reg  dup 0 FF .const  0800 and if ." subs " else ." adds " then ;

: .4XXX     ( a opc -- a )  \ Bulk of all opcodes are decoded here
    dup 0800 and if
        dup 8 7 .reg  0 FF @lit 4 *  ." pc "    \ Show destination register
        dup u. ." x) ldr "  over +  4 +         \ Get lit. & calc. address
        dup 4 mod -  @ ."  Lit: "  .hex  exit   \ Show inline literal
    then
    dup 0C00 and 0= if  .logic  exit  then  \ All basic logic opcodes
    dup 0300 and  dup 0300 = if  drop .bx  exit  then >r \ BX & BLX
    dup .ldreg  3 F .reg  r> 8 rshift  3 *  
    s" addcmpmov" drop  +  3 type space ;   \ All register opcodes

: .5XXX     ( a opc -- a )  \ Load & store using registers
    dup 0 7 .reg  dup 3 7 .reg  dup 6 7 .reg ." ) "
    0E00 and  9 rshift  5 *
    s" str  strh strb ldrsbldr  ldrh ldrb ldrsh" drop +
    5 -trailing type space ;

: .6XXX     ( a opc -- a )  \ Load & store 32-bits using 5-bits offest
    dup 4 .reg[]  0800 and if ." ldr " else ." str " then ;

: .7XXX     ( a opc -- a )  \ Load & store 8-bits using 5-bits offest
    dup 1 .reg[]  0800 and if ." ldrb " else ." strb " then ;

: .8XXX     ( a opc -- a )  \ Load & store 16-bits using 5-bits offest
    dup 2 .reg[]  0800 and if ." ldrh " else ." strh " then ;

: .9XXX     ( a opc -- a )  \ Load & store 32-bits using 5-bits offest
    dup 8 7 .reg  ." rp "  dup 0 FF 4 .indirect ." x) "
    0800 and if ." ldr " else ." str " then ;

: .AXXX     ( a opc -- a )  \ Add 8-bits number to RP & PC
    dup 8 7 .reg  dup 0800 and if  ." rp "  0 FF .const ." add "
    else  ." pc "  0 FF .const ." adr " 
    then ;
   
: .BXXX     ( opc -- )      \ Miscellaneous opcodes, PUSH, POP, etc.
    dup 0E00 and >r
    r@ 0=     if  .rsp  then
    r@ 0200 = if  .sxt  then
    r@ 0400 = if  s" lr " 2 pick 100 and .regs  ." push "  then
    r@ 0600 = if  ." cpsi" 10 and if ." d " else ." e "  then  then
    r@ 0800 = if  ." udf "  drop  then
    r@ 0A00 = if  .rev     then
    r@ 0C00 = if  s" pc " 2 pick 100 and .regs  ." pop "  then
    r> 0E00 = if  .bexx   then ;

: .CXXX     ( opc -- )      \ Load & store multiple registers
    dup 8 7 .reg  dup 0 0 0 .regs  0800 and if ." ldm " else ." stm " then ;

: .DXXX     ( a opc -- a )  \ Branch & test opcodes & supervisor mode
    dup 0F00 and  8 rshift >r  r@ 0D > if  0 FF .const  else
        FF and dup 80 and if  -1 FF xor  or  then  .jump
    then  r> 3 *  s" beqbnebcsbccbmibplbvsbvcbhiblsbgebltbgtbleudfsvc"
    drop +  3 type space ;

: .EXXX     ( a opc -- )    \ Branch eleven bits
    7FF and  dup 400 and if  -1 7FF xor  or  then  .jump ." b "  ;

: .Fxxx     ( a1 opc -- a2 ) \ 32-bits opcodes (coupled opcodes) like BL, etc.
    10 lshift  over 2 + h@  or      \ Build 32-bits opcode
    dup F800F000 and  F0008000 = if \ Valid 32-bits opcode?
        dup 003FFFC0 and  003F8F40 = if \ Barrier opcode?
            30 and 4 rshift  3 *    \ Yes, decode
            s" dsbdmbisbudf" drop + 3 type space
        else
            dup 00700000 and >r     \ No, Move special or UDF?
            r@ 00700000 = if  drop  ." udf "  then
            r@ 00600000 = if  dup 8 F .reg  .special ." mrs "   then
            r> 0= if  dup .special  10 F .reg ." msr "   then
        then  2 +to 'see  2 .data  exit
    then
    dup F800D000 and F000D000 <> 
    if  drop  ." udf "  else  .bl   then
    2 +to 'see  2 .data ;

create 'OPC ' .0xxx ,  ' .1xxx ,  ' .2xxx ,  ' .3xxx ,  ' .4xxx ,
            ' .5xxx ,  ' .6xxx ,  ' .7xxx ,  ' .8xxx ,  ' .9xxx ,
            ' .Axxx ,  ' .Bxxx ,  ' .Cxxx ,  ' .Dxxx ,  ' .Exxx ,  ' .Fxxx ,

: SKIP-CFA  ( -- 0|a )
    'see 4 mod if  0  exit  then    \ Zero when not aligned
    'see @  'see dup 20 + within if \ Max. 8 cell literals
        'see @  dup 'see cell+ >    \ Code starts not behind CFA
        if      4 +to 'see  exit    \ Yes skip CFA & to literal pool
        then    to 'see             \ Go on after CFA
    then  0 ;                       \ Nothing on other cases

: .HEAD     ( a +n -- )
    >r  dup c@ 7F and 20 < if       \ Yes, show it's a words name
        cr ." name " dup @name 2dup type
        r@ +to 'see
        nip 5 + 1C and +to 'see
    then  r> 2drop ;

: .ONELINE  ( -- )
    skip-cfa >r                 \ Handle CFA
    r@ if  cr ." - Literals - "  then \ Not zero show literal pool
    begin
    'see r@ < while             \ Until all literals done
        2 .data  2 +to 'see
        'see 4 mod if  'see 2 - @ .hex  then
    repeat  r> if  cr ." - Code - "  then
    2 .data
    'see dup h@  dup F000 and  0C rshift        \ a opc offset
    cells 'opc +  @ execute drop  2 +to 'see ;  \ -

v: forth definitions
: MDAS      ( a -- )
    to 'see
    1 for
        'see cell+ ?head ?dup       \ Check for HEADER too?
        if      4 .head
        else    'see 6 + ?head ?dup \ Aligned header?
                if  'see h@ FFFF = 
                    if  dup 6 .head  then drop
                then
        then    .oneline
    recur  next ;

: DAS       ( "name" -- )       '  mdas ;

v: fresh
shield DAS\     \ freeze  
here swap - dm .

\ End
