(*  noForth T(humb) smaller assembler (not complete!)

(c) W.O, W.J & J.J.H 2023 RP2040 ASM basic opcodes, vsn 0.6: 6412/6268 bytes

With Forth literal pool, ITC & argument macro's & most opcodes 
Rewritten paren argument macro handler for LDR, etc. smaller & correct!

Immediate:
    Opcod ddd iiiiiiii      8-bit immediate, 1 register, low
    Opcode.... iiiiiii      7-bit immediate, RP implicit
    Opcod iiiii mmm ddd     5-bit immediate, 2 registers, low
    Opcode. iii nnn ddd     3-bit immediate, 2 registers, low
Register:
    Opcode.. d .... ddd     1 register, all
    Opcode....  mmm ...     1 register, low
    Opcode....  mmm ddd     2 registers, low
    Opcode. mmm nnn ddd     3 registers, low
    Opcode.. d mmmm ddd     2 registers, all
    Opcode...  mmmm ...     1 register, all
Push, Pull:
    Opcode.  M rrrrrrrr     R0 to R7 & LI/PC (special case of 8-bit imm)
Diversen:
    Opcode..   ...i....     CPS (Whole 16-bits pattern)
    Opcode..   iiiiiiii     BKP & SVC (Special case of 8-bit imm)
    Opcode..   ........     Whole 16-bits pattern
Branches:
    Opco cccc  bbbbbbbb    Conditional branch   
    Opcod   bbbbbbbbbbb    Branch
    Opcode.. x mmmm 000    BX & BLX (Special case of 2 register, all)
32-bit opcodes:
    Opcode...... nnnn ........ rrrrrrrr     2 registers, all
    Opcode.. ........ ........ ........     Whole 32-bits pattern
    Opcod S .......... .J.J ...........     Branch & link

*)

here  hex \ noForth additions
v: inside also  assembler also  inside definitions

: REGISTER  create  ,  does> @  1 sp0 +! ;
v: assembler definitions 	\ Add register names & addressing modes
80 register IP   81 register SP   82 register W     83 register TOS
84 register HOP  85 register DAY  86 register SUN   87 register MOON
88 register WW   89 register XX   8A register YY    8B register ZZ
8C register DOES 8D register RP   8E register LR    8F register PC 
80 register R0   81 register R1   82 register R2    83 register R3

\ Addressing modes
92 constant X)   93 constant )    94 constant -)   95 constant )+
v:  92 constant #
-v: : #  state? if  postpone #  exit  then  x) ; immediate

v: inside definitions
: 16B,      ( opc -- )      false sp0 !  h, ;           \ Comma half word
: 32B,      ( opc -- )      h-h  16b, 16b, ;            \ Comma word
: ?REG      ( r r# -- +n )  >r 80 xor r> over u> -1 ?pair ; \ 0 to R# - 1
: 3REG?     ( -- f )        sp0 @ 3 = ;                 \ Three reg's used
: LIT?      ( <i*x> -- f )  dup x) = ;                  \ Literal argument
: ?RANGE-U  ( x xr -- x )   >r dup r> 1+ u< 0= ?abort ; \ Range control unsigned
: ?RANGE-S  ( x xr -- )     1+ tuck 2/ + swap u< 0= ?abort ; \ Range signed
: >DIST     ( ad ao -- o )  cell+  2/ ;             \ Calc. jump distance
: DEST-REG  ( r x1 -- x2 )  swap 8 ?reg or ;        \ Only low registers
: PLACE-REG ( r +n -- x )   >r  8 ?reg  r> lshift ; \ Idem

: 2LOW-REG  ( opc -- )      \ Rd Rn OPC,
    create ,  does> @ >r        \ Base opcode
      3 place-reg  dest-reg     \ Origin & destination register
      r> or  16b, ;             \ Construct & assemble opcode
v: assembler definitions
4000 2low-reg ANDS,   4040 2low-reg EORS,   4140 2low-reg ADCS,
4180 2low-reg SBCS,   41C0 2low-reg RORS,   4200 2low-reg TST,
4240 2low-reg NEG,    42C0 2low-reg CMN,    4300 2low-reg ORRS,
4340 2low-reg MULS,   4380 2low-reg BICS,   43C0 2low-reg MVNS,
B200 2low-reg SXTH,   B240 2low-reg SXTB,   B280 2low-reg UXTH,
B2C0 2low-reg UXTB,   BA00 2low-reg REV,    BA40 2low-reg REV16,
BAC0 2low-reg REVSH,
v: inside definitions
4080 2low-reg LSLS)   40C0 2low-reg LSRS)   4100 2low-reg ASRS)
0000 2low-reg MOVS)   4280 2low-reg CMP)  \ MOVS) = LSLS#5 with 0 shift value

: 2ALL-REG  ( opc -- )      \ Rd Rn OPC,  ( all registers )
    create ,  does> @ >r        \ Base opcode
      10 ?reg  3 lshift         \ Origin register
      swap 10 ?reg  dup 7 and   \ Add destination register
      swap 8 and  4 lshift or   \ Add highest dest. bit too
      or  r> or  16b, ;         \ Construct & assemble opcode
4400 2all-reg ADDL)     v: assembler definitions
4600 2all-reg MOV,      v: inside definitions
4500 2all-reg CMPL)     4700 2all-reg BX)

: 3LOW-REG  ( opc -- )      \ Rd Rn Rm OPC,
    create ,  does> @ >r
      6 place-reg  swap 3 place-reg or  \ Make M & N-origin register
      dest-reg  r> or 16b, ;   	\ Add destination register & assemble opcode
1800 3low-reg ADDS3)  1A00 3low-reg SUBS3)  5000 3low-reg STR3)
5400 3low-reg STRB3)  5200 3low-reg STRH3)  5C00 3low-reg LDRB3)
5A00 3low-reg LDRH3)  5800 3low-reg LDR3)
5600 3low-reg LDRSB3) 5E00 3low-reg LDRSH3)

: 2REG+IMM3, ( opc -- )         \ Rd Rn imm-3 # OPC,
    >r x) ?pair 7 ?range-u  6 lshift >r \ Handle 3-bit literal
    3 place-reg  dest-reg               \ Origin & destination register
    2r> or or 16b, ;                    \ Construct & assemble opcode

: 2REG+IMM5 ( opc -- )      \ Rd Rn imm-5 # OPC,
    create ,  does> @ >r
      x) ?pair 1F ?range-u  6 lshift >r \ Handle 5-bit literal
      3 place-reg  dest-reg             \ Origin & destination register
      2r> or or 16b, ;                  \ Construct & assemble opcode
0000 2reg+imm5 LSLS#5  0800 2reg+imm5 LSRS#5   1000 2reg+imm5 ASRS#5
6000 2reg+imm5 STR#5   7000 2reg+imm5 STRB#5   8000 2reg+imm5 STRH#5
6800 2reg+imm5 LDR#5   7800 2reg+imm5 LDRB#5   8800 2reg+imm5 LDRH#5

: SP+IMM7,  ( i*x opc -- )  \ RP imm-7 # OPC,
    >r  x) ?pair 2/ 2/  swap RP ?pair  7F ?range-u  r> or 16b, ;

: 1REG+IMM8 ( opc -- )      \ Rd imm-8 # OPC,
    create ,  does> @ >r
      x) ?pair  r@ A000 = if 2/ 2/ then \ ADR, convert to cell offset
      dup 100 and  dup if               \ Literal? check for LR/PC data
        r@ BC00 = r@ B400 = or -1 ?pair \ These are only valid for PUSH & POP!
      then  
      swap FF and  FF ?range-u or       \ Check & add 8-bit literal
      swap 8 place-reg or  r> or 16b, ; \ Add dest. register & assemble opcode

v: assembler definitions
333 constant {              \ Control number, for '}' 
: }   ( ... -- bitmasker )  \ works in definitions too
    false   \ Start mask at zero
    begin   swap dup 80 and             \ Is it a register?
    while   80 xor dup 8 E within ?abort \ Invalid register?
            8 min  1 swap lshift  or    \ R0 to R7 plus PC & LR add
    repeat  333 ?pair  x) ;             \ Check security, leave arguments

v: inside definitions          
3000 1reg+imm8 ADDS#8   3800 1reg+imm8 SUBS#8
2000 1reg+imm8 MOVS#8   2800 1reg+imm8 CMP#8
9000 1reg+imm8 STRSP#8  9800 1reg+imm8 LDRSP#8
4800 1reg+imm8 LDR#8    A800 1reg+imm8 ADDSP#8
B400 1reg+imm8 PUSH)    BC00 1reg+imm8 POP)
v: assembler definitions
A000 1reg+imm8 ADR,  C000 1reg+imm8 STM,  C800 1reg+imm8 LDM,

\ 16-bits no operand opcodes ( -- )
: NOOP,     ww ww mov, ;
: CPSIE,    B662 16b, ;      : CPSID,    B672 16b, ;

\ Add multi format opcodes:
: ADD,      ( i*x -- )
    lit? 0= if  addl) exit  then   \ Register data: Rd Rn add
    drop >r  2dup xor 0=  over RP = and \ No, registers both RP?
    if  drop  r> x) B000 sp+imm7, exit \ RP RP imm7 # add
    then   dup RP =                 \ Org. is RP?
    if  drop r> 2/ 2/ x) addsp#8 exit  then \ Yes, Rd RP imm8 # add 
    PC ?pair  r> x) adr, ;          \ No, Rd PC imm8 # add
: ADDS,     ( i*x -- )
    lit? 0= if  adds3) exit  then  \ Register data: Rd Rn Rm adds
    2>r  2dup xor 8 u< if  2r> 1C00 2reg+imm3, \ Two arg: Rd Rn imm-3 # adds
    else  2r> adds#8  then ;       \ Rd imm-8 # adds
: SUBS,     ( i*x -- )
    lit? 0= if  subs3) exit  then  \ Not literal data?; Rd Rn Rm subs
    2>r  2dup xor 8 u<  over RP <> and \ Two register opcode?
    if  2r> 1E00 2reg+imm3, exit  then \ Yes; Rd Rn imm-3 # subs
    dup RP <> if  2r> subs#8 exit then \ No RP only; Rd s imm-8 # subs
    RP ?pair  r> r> swap B080 sp+imm7, ; \ No; Rd RP imm-7 # subs
: MOVS,     ( i? -- )       \ Rd imm-8 # movs | Rd Rn movs
    lit? if  movs#8  else  movs)  then ;
: CMP,      ( i*x -- )
    lit? if  cmp#8 exit  then       \ Rd imm-8 # cmp
    2dup max  80 xor 8 <            \ Largest register less then 8
    if  cmp)  else  cmpl)  then ;   \ Low or all: Rd Rn cmp
: LSLS,     ( i*x -- )      lit? if lsls#5 else lsls) then ;
: LSRS,     ( i*x -- )      lit? if lsrs#5 else lsrs) then ;
: ASRS,     ( i*x -- )      lit? if asrs#5 else asrs) then ;

v: inside definitions
: PAREN     ( r r ra +n -- +p r r ar )  \ Handle: )  x)  )+  -)   \ r r 'ar' +n
    over x) = if                        \ x) ?                    \ r r +n ar
        drop  2>r 2>r false 2r> 2r> exit \ Add no p+ to stack     \ 0 r r +n ar
    then
    >r  dup )+ = if  over r@ h+h        \ Post increment?         \ r r ar p+
    else  false  then                                             \ r r ar 0
    -rot 2>r  swap 2r>                  \ Correct stack order     \ p|0 r r ar
    -) = if                             \ Pre decrement?          \ p|0 r r
        dup dup r@ x) subs,             \ Yes, add opcode         \ p|0 r r 
    then  false x)  rdrop ;             \ Default addressing mode \ p|0 r r 0 ar
: PAREN+    ( +p -- )
    ?dup if                             \ Post increment?
        h-h over RP =                   \ Yes, RP used?
        if  over swap x) add,           \ Ok, use RP addition
        else  x) adds,  then            \ No, other addition
    then ;

v: assembler definitions
: STR,      ( i*x -- )  \ rs rb rm ) str/ldr - rs rb imm x) str/ldr
    3reg? if ) ?pair  str3) exit then       \ Rs Rb Rm str
    4 paren  drop  2/ 2/ >r  dup RP = if    \ Using RP? -- also )  )+  -)
        drop  r> x) strsp#8                 \ Rs RP imm8 x) str
    else  r> x) str#5  then  paren+ ;       \ Rs Rb imm5 x) str

: LDR,      ( i*x -- )  \ rd rn <x> LDR,
    3reg? if ) ?pair ldr3) exit then        \ Rd Rn Rm ldr
( ) dup )+ = if                             \ Optimise )+ separately?
( )     over WW < if                        \ Yes, ...
( )         drop  1 rot 80 xor lshift  x) ldm, \ Yes, replace by LDM
( )         exit
( )     then
    then  4 paren  drop  2/ 2/ >r  dup PC = \ Using PC? -- also )  )+  -)
    if  drop r> x) ldr#8  DROP exit  then   \ Rd pc imm8 # ldr
    dup RP = if  drop  r> x) ldrsp#8        \ RP?   Rd RP imm8 # ldr
    else  r> x) ldr#5  then  paren+ ;       \ No,   Rd Rn imm5 # ldr

: STRB,     ( i*x -- )
    3reg? if  ) ?pair  strb3) exit  then	\ Rs Rb Rm strb
    1 paren  strb#5  paren+ ;				\ Rs Rb imm5 x) strb
: LDRB,     ( i*x -- )
    3reg? if  ) ?pair  ldrb3) exit  then	\ Rs Rb Rm ldrb
    1 paren  ldrb#5  paren+ ;				\ Rs Rb imm5 x)ldrb, also ) )+ -)

: STRH,     ( i*x -- )
    3reg? if  ) ?pair  strh3) exit then		\ Rs Rb Rm strh
    2 paren  swap 2/ swap strh#5  paren+ ;	\ Rs Rb imm5 x) strh, also ) )+ -)
: LDRH,     ( i*x -- )
    3reg? if  ) ?pair  ldrh3) exit then		\ Rs Rb Rm ldrh
    2 paren  swap 2/ swap ldrh#5  paren+ ;	\ Rs Rb imm5 x) ldrh, also ) )+ -)

: LDRSB,    ( i*x -- )      ) ?pair  ldrsb3) ;
: LDRSH,    ( i*x -- )      ) ?pair  ldrsh3) ;

\ Compose slightly different opcodes
: SUB,      rot RP ?pair  B080 sp+imm7, ; \ RP imm7 # sub
: RSBS,     x) ?pair  false ?pair  neg, ;
: BX,       r0 swap bx) ;     : BLX,      ww swap bx) ;
: POP,      r0 -rot pop) ;    : PUSH,     r0 -rot push) ;

v: inside definitions
\ .....7FF - 11 bits, bit 0 to 10   ..1FF800 - 10 bits, bit 11 to 20
\ ..600000 -  2 bits, bit 21 & 22   ..800000 - Sign bit, bit 23
: BL)       ( ad ao -- opc ) \ 32-bits branch & link opcode, range is 24-bits
    >dist  dup FFFFFF ?range-s      \ Calc. offset & check range 
    F000D000  over 7FF and or       \ Add first 11 bits to basic opcode
    over 1FF800 and  5 lshift or    \ Add next 10 bits
    over 0< >r  swap 0A rshift      \ Save sign & get bit 21&22 to bit 11&12
    invert  r@ xor  dup 800 and     \ Invert & add sign to J1 & J2, J2 is ok
    swap 1000 and  2* or  or        \ J1 to bit 13 & add to J2 and to opcode
    r> 4000000 and or ;             \ Add J1, J2 and sign, generate opcode      

\ Forth conditionals, structure data & security are marked with an 's'
\ Dx00: 0=EQ,  1=NE, 2=CS, 3=CC, 4=Minus (0<), 5=PL (Pos), 6=VS (Overflow)
\       7=VC (No overflow), 8=HI (U>), 9=LS (U<=), A=GE (>=), B=LT (<), 
\       C=GT (>), D=LE (<=), E=AL (Always)
: ?DIST     ( n opc -- n )  \ Build 7 or 11-bit branch offset
    E000 =  700 and  FF or >r  dup r@ ?range-s  r> and ;

\ 55 constant SYS-CODE      \ Code structure
\ 66 constant SYS-IF,       \ for then, ahead, repeat,
\ 77 constant SYS-BEGIN,    \ for until, again, repeat,
\ 88 constant SYS-COND      \ Conditionals
\ 99 constant SYS-POOL      \ Pool structure
: CONDITIONAL   create ,  does> @ 88 ; ( -- c s )
v: assembler definitions
    D100 conditional =?     D300 conditional CS?    D500 conditional NEG?
    D700 conditional VS?    D900 conditional U>?    DA00 conditional <?
    DD00 conditional >?

: NO        ( c1 -- c2 )    88 ?pair  100 xor  88 ;

: IF,       ( c -- s )
    88 ?pair  here  swap 16b,  66 ; \ Compile opcode, leave data
: THEN,     ( s -- )
    66 ?pair >r  here r@ >dist      \ Check structure & calc. offset 
    r@ h@ ?dist  r@ h@ or  r> h! ;  \ Check and add jump forward
: AHEAD,    ( -- s )        E000 88 if, ;    
: ELSE,     ( s0 -- s1 )    ahead,  2swap  then, ; \ Jump always, resolve IF,

: UNTIL,    ( s c -- )
    88 <> ?ABORT >r  77 ?pair           \ Valid structure
    here >dist  r@ ?dist  r> or 16b, ;  \ Check & assemble jump backwards
: BEGIN,    ( -- s )            here  77 ;       \ Leave data only
: AGAIN,    ( s -- )            E000 88 until, ; \ Jump to BEGIN,
: WHILE,    ( s0 c -- s1 s0 )   if,  2swap ;     \ Stay in loop on condition
: REPEAT,   ( s1 s0 -- )        again, then, ;   \ Close a BEGIN, WHILE, loop
: BL,       ( a -- )            here bl)  32b, ; \ Jump & link to address 'a'

v: inside also
: CODE>     ( -- )  55 ?pair  here swap !  here 55 ; \ End pool start code

\ v: extra definitions
\ : NEXT,     ( -- )          ip { w } ldm,  w { hop } ldm,  pc hop mov, ;
\ : ROUTINE   ( "name" -- a ) create  here cell- 55  0 sp0 ! ;
\ : END-CODE  ( s -- )        previous also  55 ?pair  sp0 @ ?exit  reveal ;
\
\ v: forth definitions
\ : CODE      ( "name" -- s ) create  0 sp0 ! ;

v: fresh
here swap -  dm .

hex
shield ASM\
