(* Changing the configuration of noForth T

    CFG      = Clock frequency in Hz
    CFG 04 + = Used UART ( 0 or 1 ) only 0 is valid for now
    CFG 08 + = Baudrate in bits per second 
    CFG 0C + = Used GPIO pin for S?
    
    GROW     = Resize noForth with the number of bytes from the stack

Valid data for these parameters are:
    Clock    = 12, 30, 60, 120, 125 to 132 MHz
    Uart     = 0  (will be upgraded when this version is stable)
    Baudrate = Any baudrate like 9600, 115200 until 921600 was tested ok
    S? pin   = GPIO 24, but any free GPIO pin will do

    FREEZE   = Save bootup image
    FREEZE2  = Save spare image
    COLD     = (Re)load bootup image
    COLD2    = (Re)load spare image

*)

decimal  cfg
132     over !  cell+   \ Set maximal valid frequency in MHz
0       over !  cell+   \ Use UART-0
460800  over !  cell+   \ Baudrate is 460k8
24      swap !          \ Use GPIO-24 for S?
hex

  cfg config    \ Test new configuration
\ freeze        \ Save new configuration, boots at startup & when you type COLD
\ freeze2       \ Save as spare system, boots when you type COLD2

\ End
