\ Extended assembler opcodes for RP2040, 1180 bytes.

here
v: inside also  assembler also definitions
100 constant APSR     101 constant IAPSR    102 constant EAPSR
103 constant XPSR     105 constant IPSR     106 constant EPSR
107 constant IEPSR    108 constant MSP      109 constant PSP
110 constant PRIMASK  114 constant CONTROL


v: inside definitions
: ?SPECIAL  ( r -- +n )     100 xor  dup 15 u< 0=  0 ?arg ;     \ 0 to 14

BE00 1reg+imm8 BKPT)    DE00 1reg+imm8 UDF)     DF00 1reg+imm8 SVC)


v: assembler definitions \ Hint instructions!
: NOP,      BF00 16b, ;
: YIELD,    BF10 16b, ;      : WFE,      BF20 16b, ;
: WFI,      BF30 16b, ;      : SEV,      BF40 16b, ;


\ 32-bits no operand opcodes barrier opcodes
: DSB,      F3BF8F4F 32b, ;  : DMB,      F3BF8F5F 32b, ;
: ISB,      F3BF8F6F 32b, ;


\ 32-bits 2 operand opcodes, special registrer opcodes
: MSR,      ( spr Rn -- )   \ <spec> Rn msr
    10 ?reg 10 lshift  F3808800 or  swap ?special  or 32b, ;
: MRS,      ( rd spr -- )   \ Rd <spec> mrs
    ?special  F3EF8000 or  swap 10 ?reg 08 lshift  or 32b, ;


\ Compose slightly different opcodes, supervisor & breakpoint
: SVC,      moon -rot svc) ;
: BKPT,     r0 -rot bkpt) ;   : UDF,      r0 -rot udf) ;


v: inside definitions \ Literal pool extensions
: #)        ( x a -- )  \ Compile literal & patch LDR opcode
    >r  here r@  r@ 4 mod if 2 + then   \ Correct LDR to constant distance
    -  4 /  dup .                       \ Calc. & show LDR offset
    r@ 2 - h@ dup                       \ Fetch & show opcode
    F8FF and 4800 <> ?abort             \ Message for invalid opcode!
    or r> 2 - h!  32b, ;                \ Patch LDR opcode & compile number

v: assembler definitions
: ALIGN, ( -- )      here 4 mod if noop, then ; \ Align opcode
: ##     ( x a -- )  here  ahead, 2>r  align,  #)  2r> then, ; \ Simple pool
: POOL,  ( -- s )    w pc mov,  ahead, ; \ Jump over non aligned inline pool
: APOOL, ( -- s )    align,  pool, ;     \ Jump over aligned inline pool

shield +ASM\
here swap - dm .
v: fresh

\ End
